package app.firezone.synk.network;

import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.LinearLayoutManager;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.google.firebase.database.DatabaseReference;
import com.squareup.picasso.Picasso;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.BgmiPlayerAdapter;
import app.firezone.synk.network.Adapter.RulesAdapter;
import app.firezone.synk.network.databinding.ActivityBgmiOneBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.CheckJoinedResponse;
import app.firezone.synk.network.model.Joined_Match_Model;
import app.firezone.synk.network.model.MatchResponse;
import app.firezone.synk.network.model.MatchRulesResponse;
import app.firezone.synk.network.model.Match_Model;
import app.firezone.synk.network.model.RulesModel;
import app.firezone.synk.network.model.User;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.util.ArrayList;


public class Bgmi_Activity_One extends AppCompatActivity {


    ActivityBgmiOneBinding binding;
    BgmiPlayerAdapter mAdapter;

    ArrayList<Joined_Match_Model> mlist;

    private ClipboardManager myClipboard;
    private ClipData myClip;


    long userId;

    ArrayList<RulesModel> rulesModels;

    RulesAdapter adapter;

    ProgressDialog progressDialog;

    Dialog dialog;

    String gamename ,teamType, matchNo, roomId, roomPass;

    boolean joinedUsers;
    DatabaseReference dr ,dr2, dr3, dr4;
    long winBalance, depoBalance, bonusBalance, totalCoin, entryFee, totalFee, matchPlayed, totalPlayer, player;

    EditText ffUsername1, ffUsername2, ffUsername3, ffUsername4;

    TextView spersonTxt;

    private boolean isLoading = false;

    private MyApi myApi;

    long matchId;

    ConstraintLayout addPlayers, playerConstraint1, playerConstraint2, playerConstraint3, playerConstraint4;
    String  email, name;



    @SuppressLint("MissingInflatedId")
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityBgmiOneBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        binding.backArrow.setOnClickListener(v -> finish());
        myClipboard = (ClipboardManager) getSystemService(CLIPBOARD_SERVICE);
        progressDialog = new ProgressDialog(Bgmi_Activity_One.this);
        progressDialog.setTitle("Joining Match");
        progressDialog.setMessage("Please Wait.....");
        progressDialog.setCancelable(true);

         myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);

        gamename = getIntent().getStringExtra("gamename");
        binding.toolText.setText(gamename);
        String totalPlayers  = getIntent().getStringExtra("totalPlayer");
        String entryFees  = getIntent().getStringExtra("entryFee");
        totalPlayer = Long.parseLong(totalPlayers);
        entryFee = Long.parseLong(entryFees);

        userId = SharedPrefManager.getInstance(Bgmi_Activity_One.this).getUserId();

        loadData();


        Bundle extras = getIntent().getExtras();
        if (extras != null && extras.containsKey("matchid")) {
            matchId = extras.getLong("matchid");
            if (matchId != 0) {
                fetchMatchData(matchId);
            } else {
                Toast.makeText(this, "Match ID is invalid", Toast.LENGTH_SHORT).show();
            }
        } else {
            Toast.makeText(this, "Match ID not found", Toast.LENGTH_SHORT).show();
        }

        checkJoinedUsers();

        binding.joinedRecy.setLayoutManager(new LinearLayoutManager(this));
        mlist = new ArrayList<Joined_Match_Model>();


            Call<ArrayList<Joined_Match_Model>> joinedUserData = myApi.fetchMatchJoinedUsers(matchId);
            joinedUserData.enqueue(new Callback<ArrayList<Joined_Match_Model>>() {
                @Override
                public void onResponse(Call<ArrayList<Joined_Match_Model>> call, Response<ArrayList<Joined_Match_Model>> response) {
                    if (response.isSuccessful() && response.body() != null) {
                        mlist.clear();
                        mlist.addAll(response.body());

                        long child = mlist.size();
                        if (child >= totalPlayer) {
                            binding.joinText.setText("Match Full");
                            binding.subssribeBtn.setBackgroundResource(R.drawable.btn_false);
                            binding.subssribeBtn.setClickable(false);
                        } else {
                            binding.joinText.setText("Join Match");
                            binding.subssribeBtn.setClickable(true);
                        }

                        mAdapter = new BgmiPlayerAdapter(mlist, Bgmi_Activity_One.this);
                        binding.joinedRecy.setAdapter(mAdapter);

                    } else {
                        Toast.makeText(Bgmi_Activity_One.this, "No data available.", Toast.LENGTH_SHORT).show();
                    }
                }

                @Override
                public void onFailure(Call<ArrayList<Joined_Match_Model>> call, Throwable throwable) {
                    Toast.makeText(Bgmi_Activity_One.this, "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
                }
            });


        binding.rulesRecy.setLayoutManager(new LinearLayoutManager(this));
        rulesModels = new ArrayList<>();

        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);
        Call<MatchRulesResponse> call = myApi.fetchMatchRules(gamename);

        call.enqueue(new Callback<MatchRulesResponse>() {
            @Override
            public void onResponse(Call<MatchRulesResponse> call, Response<MatchRulesResponse> response) {
                if (response.isSuccessful() && response.body() != null && response.body().isSuccess()) {
                    rulesModels.clear();
                    rulesModels.addAll(response.body().getMatchRules());
                    adapter = new RulesAdapter(rulesModels, Bgmi_Activity_One.this);
                    binding.rulesRecy.setAdapter(adapter);
                } else {
                  //  Toast.makeText(Bgmi_Activity_One.this, "No Rules Found: " + (response.body() != null ? response.body().getMessage() : "Unknown Error"), Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<MatchRulesResponse> call, Throwable t) {
                Toast.makeText(Bgmi_Activity_One.this, "Failed to load rules: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });


        binding.roomPassCopy.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                String text = binding.roomPass.getText().toString();
                myClip = ClipData.newPlainText("text", text);
                myClipboard.setPrimaryClip(myClip);
                Toast.makeText(getApplicationContext(), "Room Pass Copied",
                        Toast.LENGTH_SHORT).show();
            }
        });


        binding.roomIdCopy.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                String text = binding.roomId.getText().toString();
                myClip = ClipData.newPlainText("text", text);
                myClipboard.setPrimaryClip(myClip);
                Toast.makeText(getApplicationContext(), "Room Id Copied",
                        Toast.LENGTH_SHORT).show();
            }
        });

        binding.subssribeBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent =  new Intent(Bgmi_Activity_One.this, MatchSlotsActivity.class);
                intent.putExtra("teamType", teamType);
                intent.putExtra("totalPlayer", totalPlayer);
                intent.putExtra("matchId", matchId);
                intent.putExtra("gamename", gamename);
                intent.putExtra("entryFee", entryFee);
                startActivity(intent);

            }
        });

    }

    private void fetchMatchData(long matchId) {

        binding.shimmerLayout.setVisibility(View.VISIBLE);
        binding.shimmerLayout.startShimmer();
        binding.contentLayout.setVisibility(View.GONE); // hide content

        Call<MatchResponse> matchData = myApi.getMatchDataById(matchId);

        matchData.enqueue(new Callback<MatchResponse>() {
            @Override
            public void onResponse(Call<MatchResponse> call, Response<MatchResponse> response) {
                binding.shimmerLayout.stopShimmer();
                binding.shimmerLayout.setVisibility(View.GONE);
                binding.contentLayout.setVisibility(View.VISIBLE); // show actual content
                binding.cardView19.setVisibility(View.VISIBLE);
                if (response.isSuccessful() && response.body() != null && response.body().getMatch() != null) {
                    Match_Model model = response.body().getMatch();
                    binding.perkill.setText("₹" + (TextUtils.isEmpty(model.getPerkill()) ? "0" : model.getPerkill()));
                    binding.prizepool.setText("₹" + (TextUtils.isEmpty(model.getPrizepool()) ? "0" : model.getPrizepool()));
                    binding.teamTypes.setText("#" + (TextUtils.isEmpty(model.getTeamtype()) ? "N/A" : model.getTeamtype()) + " Match");
                    binding.teamType.setText(model.getTeamtype());
                    binding.entryfee.setText("₹" + model.getEntryfee() + "/Person");
                    binding.entryprice.setText("Pay ₹" + model.getEntryfee());
                    binding.dateTxt.setText(model.getDate());
                    binding.playerWisePrize.setText(model.getPlayerPrize());
                    binding.timeTxt.setText(model.getTime());
                    binding.matchMap.setText(model.getMap());
                    binding.matchType.setText(model.getMatchType());
                    binding.matchName.setText(model.getGamename()+ " ( SKILL GAME ) - Match" + model.getMatchno());

                    if (entryFee >=1){
                        binding.matchType.setText("Paid");
                    }else {
                        binding.matchType.setText("Free");
                    }


                    teamType = model.getTeamtype();
                    matchNo = model.getMatchno();
                    roomId = model.getRoomid();
                    roomPass = model.getRoompass();

                    if ("Ongoing".equalsIgnoreCase(model.getMatchstatus())) {
                        binding.joinText.setText("Match Started");
                        binding.subssribeBtn.setBackgroundResource(R.drawable.btn_false);
                        binding.subssribeBtn.setClickable(false);
                        binding.btnImages.setVisibility(View.INVISIBLE);
                        binding.cardView22.setVisibility(View.VISIBLE);
                    }

                    if (joinedUsers) {
                        binding.roomId.setText(model.getRoomid());
                        binding.roomPass.setText(model.getRoompass());
                        binding.cardView19.setVisibility(View.GONE);
                    } else {
                        binding.roomId.setText("Not Joined");
                        binding.roomPass.setText("Not Joined");
                    }

                    Picasso.get()
                            .load(model.getImages())
                            .placeholder(R.drawable.loading_img)
                            .into(binding.imageView5);

                } else {
                    Toast.makeText(getApplicationContext(), "No Match Data Found", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<MatchResponse> call, Throwable throwable) {
                Toast.makeText(getApplicationContext(), "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    public void checkJoinedUsers() {

        Call<CheckJoinedResponse> call = myApi.checkIfUserJoined(userId, matchId);

        call.enqueue(new Callback<CheckJoinedResponse>() {
            @Override
            public void onResponse(Call<CheckJoinedResponse> call, Response<CheckJoinedResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    CheckJoinedResponse responseBody = response.body();

                    if (responseBody.isSuccess()) {
                        binding.joinText.setText("Joined");
                        binding.subssribeBtn.setCardBackgroundColor(getColor(R.color.gray));
                        binding.subssribeBtn.setClickable(false);
                        binding.cardView19.setVisibility(View.GONE);
                        binding.btnImages.setVisibility(View.GONE);
                        joinedUsers = true;

                        binding.roomId.setText(roomId);
                        binding.roomPass.setText(roomPass);

                        Toast.makeText(Bgmi_Activity_One.this, responseBody.getMessage(), Toast.LENGTH_SHORT).show();
                    } else {
                        binding.joinText.setText("Join Now");
                        joinedUsers = false;
                        binding.roomId.setText("Not Joined");
                        binding.roomPass.setText("Not Joined");
                        Toast.makeText(Bgmi_Activity_One.this, responseBody.getMessage(), Toast.LENGTH_SHORT).show();
                    }
                } else {
                    // nothing
                }
            }

            @Override
            public void onFailure(Call<CheckJoinedResponse> call, Throwable throwable) {
                Toast.makeText(Bgmi_Activity_One.this, "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void loadData() {

        if (userId <= 0) {
            Toast.makeText(this, "Invalid user ID", Toast.LENGTH_SHORT).show();
            return;
        }
        Call<ApiResponse> call = myApi.fetchProfileData(userId);
        call.enqueue(new Callback<ApiResponse>() {
            @Override
            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    User model = response.body().getUser();

                    winBalance = model.getWinBalance();
                    depoBalance = model.getDepoBalance();
                    bonusBalance = model.getBonusBalance();

                    matchPlayed =  model.getMatchPlayed();

                    totalCoin = model.getDepoBalance() + model.getWinBalance();


                    email = model.getEmail();
                    name = model.getName();
                } else {
                    Toast.makeText(Bgmi_Activity_One.this, "Failed to fetch user data", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ApiResponse> call, Throwable throwable) {

            }
        });

    }

}